#### **1. File Integrity Checking Tools**

- **Purpose**: Detect unauthorized modifications to system files.
    - Attackers often alter system files to maintain access and evade detection.
- **How They Work**:
    - Calculate hash values for important files.
    - Store the hash values and periodically compare them to newly computed hashes.
    - Mismatched hash values indicate a file has been altered.
- **Examples of Tools**:
    - Built into most host-based IPSs.
    - Open-source tools like Tripwire and Advanced Intrusion Detection Environment (AIDE).

---

#### **2. Best Practices for File Integrity Checking**

- **Initial Check**:
    - Run file integrity tools on a system when it is first installed to establish a baseline.
- **Subsequent Checks**:
    - Run the tool after system updates or when a compromise is suspected.
- **Consideration for System Patches**:
    - Patching modifies files, so hash mismatches after patches may not indicate malicious activity.

---

#### **3. Software Image Validation for Network Devices**

- **Why It’s Important**:
    - Attackers can compromise a device’s integrity by modifying its software image.
    - Example: In 2015, attackers gained control of routers by altering software images.
- **Validation Process**:
    - Ensure all software images running on network devices are legitimate and untampered.
    - Digital signatures authenticate the software image.

---

#### **4. Example: Cisco Secure Firewall ASA Image Validation**

- **Digital Signature Verification**:
    - Cisco Secure Firewall ASA images are digitally signed to confirm authenticity.
    - The Cisco public key, bundled with the image, decrypts the digital signature.
- **Validation Command**:
    - Example: `verify <image-name>` command used to validate the image.
    - If the computed hash matches the embedded hash, the image is valid.

---

#### **5. Sample Validation Output**

- **Command**: `verify lfbff.SSA`
- **Result**:
    - **Computed Hash SHA2** and **Embedded Hash SHA2** match, confirming the image is valid.
    - Digital signature successfully validated.

---

### **Key Takeaways**

- File integrity tools are essential for detecting unauthorized changes to files, but they must be used strategically.
- Software image validation is critical for ensuring the integrity of network devices, especially in environments prone to attacks.
- Cisco Secure Firewall ASA provides built-in tools for verifying image authenticity using digital signatures.